---
publishDate: 2026-01-05T00:00:00Z
translatedSlug: automation-recorder-harava
title: 'Automation Recorder — Harava – Record & Replay Mouse & Keyboard Actions'
excerpt: 'Free & powerful automation tool. Record clicks, drags & keystrokes — replay them instantly. Save hours on repetitive tasks. Loop 1-1000x.'
lang: en
tags:
  - desktop-app
  - automation
  - productivity
  - windows
  - free-software
  - product-download
metadata:
  canonical: https://nyxa.one/automation-recorder-harava
productInfo:
  badge: 'FREE'
  badgeColor: 'from-blue-500 to-indigo-600'
  badgeAnimation: 'animate-pulse'
  image: '~/assets/images/automation-recorder-icon.png'
  version: 'v1.0.0'
  size: '~1 MB'
  downloads: 'Fresh Release'
  rating: '5.0'
  releaseDate: '5 Jan 2026'
  downloadUrl: 'https://github.com/[your-repo]/AutomationRecorder/releases'
---

<div class="my-10">
  <div class="flex items-center gap-6 mb-8">
    <img src="~/assets/images/automation-recorder-icon.png"
         alt="Automation Recorder — Harava" class="w-24 h-24 rounded-2xl object-contain border border-gray-200 shadow-lg">
    <div>
      <h1 class="text-4xl md:text-5xl font-bold mb-2 text-gray-900">Automation Recorder — Harava</h1>
      <p class="text-xl text-gray-600">Record & Replay Your Actions — Automate Everything</p>
    </div>
  </div>
</div>

<div class="bg-gradient-to-r from-blue-50 to-indigo-50 rounded-2xl p-8 mb-10 border border-blue-200">
  <div class="flex flex-wrap gap-3 mb-6">
    <span class="px-4 py-2 rounded-full text-sm font-bold text-white bg-gradient-to-r from-blue-500 to-indigo-600 shadow-sm animate-pulse">100% FREE</span>
    <span class="px-4 py-2 rounded-full text-sm font-medium bg-green-500 text-white">Open Source</span>
    <span class="px-4 py-2 rounded-full text-sm font-medium bg-purple-500 text-white">v1.0.0</span>
    <span class="px-4 py-2 rounded-full text-sm font-medium bg-orange-500 text-white">~1 MB</span>
    <span class="px-4 py-2 rounded-full text-sm font-medium bg-pink-500 text-white">Windows & Linux</span>
  </div>

  <div class="grid md:grid-cols-3 gap-6 mb-8">
    <div class="text-center">
      <div class="text-3xl font-bold text-blue-600">Fresh Release</div>
      <div class="text-gray-600">Just Launched</div>
    </div>
    <div class="text-center">
      <div class="text-3xl font-bold text-blue-600">5.0 ⭐</div>
      <div class="text-gray-600">User Rating</div>
    </div>
    <div class="text-center">
      <div class="text-3xl font-bold text-blue-600">Jan 5, 2026</div>
      <div class="text-gray-600">Release Date</div>
    </div>
  </div>

  <div class="flex gap-4">
    <a href="https://github.com/[your-repo]/AutomationRecorder/releases"
       class="block w-full md:w-auto md:inline-block text-center py-4 px-8 rounded-xl text-white font-bold gradient-cta hover:gradient-cta transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
      Download for Windows →
    </a>
    <a href="https://github.com/[your-repo]/AutomationRecorder"
       class="block w-full md:w-auto md:inline-block text-center py-4 px-8 rounded-xl text-blue-600 font-bold border-2 border-blue-600 hover:bg-blue-50 transition-all duration-300">
      View on GitHub
    </a>
  </div>
</div>

## Overview

**Automation Recorder** is a revolutionary **100% free** desktop application that records your mouse clicks, drags, and keyboard actions — then replays them with pixel-perfect accuracy. Save hours on repetitive tasks by automating them in seconds.

**Fast. Free. Powerful.**

### Key Features

- **🎬 Record Everything** – Mouse clicks (left/right/middle), drags, keystrokes
- **▶️ Instant Replay** – Play back your actions with millisecond precision
- **🔁 Loop 1-1000x** – Repeat tasks automatically up to 1000 times
- **⚡ Speed Control** – 0.1x - 5.0x playback speed (slow-mo to 5x fast)
- **🎯 Pixel-Perfect** – Exact coordinate tracking
- **⌨️ Global Hotkeys** – F1-F5 work anywhere (even in games!)
- **💾 Save & Load** – Store unlimited recordings as JSON files
- **📜 History Management** – Browse, load, delete past recordings
- **🖱️ Human-Like Movement** – Smooth mouse curves (not robotic teleporting)
- **🆓 Completely Free** – No trials, no subscriptions, no limitations

## How It Works

```
Press F1 → Do your actions → Press F2 → Press F3
         ✨ Magic! It repeats perfectly! ✨
```

### 4-Step Automation:

1. **Press F1** (Start Recording)
2. **Perform actions** (clicks, typing, drags)
3. **Press F2** (Stop Recording)
4. **Press F3** (Replay) — Watch it automate!

### Loop Mode:

```
Record → Set Loop Count (e.g., 100) → Play Loop
        ✨ Repeats 100 times automatically! ✨
```

## Use Cases

### 📊 Data Entry & Forms
**Problem:** Fill the same form 100 times
**Solution:** Record once, loop 100x
**Time Saved:** 95% (from 2 hours → 6 minutes)

### 🎮 Gaming Automation
**Problem:** Repetitive clicking/grinding
**Solution:** Record the sequence, loop it
**Time Saved:** Play while automation works

### 💼 Office Work
**Problem:** Same workflow every day
**Solution:** Record and replay daily
**Time Saved:** Hours per week

### 🧪 Software Testing
**Problem:** Test the same flow repeatedly
**Solution:** Automated test playback
**Time Saved:** 80% testing time

### 🖱️ Complex Mouse Paths
**Problem:** Precise drag-and-drop sequences
**Solution:** Record once, replay perfectly
**Time Saved:** No more mistakes

### 📧 Email Templates
**Problem:** Type the same email structure
**Solution:** Record typing + clicks
**Time Saved:** 50% on repetitive emails

## Real Examples

### Example 1: Form Filling Automation

```
1. Press F1
2. Click "Name" field
3. Type "John Doe"
4. Press Tab
5. Type "john@example.com"
6. Click "Submit"
7. Press F2

✅ Recording saved!
→ Press F3 to replay
→ Set Loop 50x → Fill 50 forms automatically!
```

**Time:** 30 seconds to record, saves 2 hours on 50 forms

### Example 2: Drag & Drop Automation

```
1. Press F1
2. Click file #1, drag to folder
3. Wait 2 seconds (auto-recorded)
4. Click file #2, drag to folder
5. Press F2

✅ Recorded!
→ Press F3 → Both drags replay perfectly
→ Set Loop 20x → Move 40 files automatically
```

**Time:** 20 seconds to record, saves 10 minutes

### Example 3: Multi-Step Workflow

```
1. Press F1
2. Open app → Click menu → Select option → Save
3. Press F2
4. Set Playback Speed = 2.0x (double speed)
5. Set Loop = 10
6. Press "Play Loop Record"

✅ Workflow repeats 10x at 2x speed!
```

**Time:** 1 minute to record, saves 30 minutes

## Settings & Customization

### ⚡ Playback Speed
- **0.1x** – Super slow (debugging/demo)
- **1.0x** – Normal (recorded speed)
- **2.0x** – 2x speed (twice as fast)
- **5.0x** – Lightning fast (5x speed)

### 🖱️ Mouse Movement Smoothness
- **0.0** – Straight line (robotic)
- **0.2** – Default (human-like)
- **0.5** – Very wavy (natural but imprecise)

### 💾 Auto-Save
- **ON** (default) – Recordings auto-save as JSON
- **OFF** – Temporary recording only

### ⌨️ Global Hotkeys
- **F1** – Start Recording
- **F2** – Stop Recording/Playback
- **F3** – Play Recording
- **F4** – Clear Events
- **F5** – Exit Application

*Works everywhere — even when app is minimized!*

## Why Automation Recorder?

| Feature | Automation Recorder | Competitors |
|---------|---------------------|-------------|
| **Price** | ✅ 100% FREE Forever | ❌ $20-100 |
| **Loop Recordings** | ✅ 1-1000x | ⚠️ Limited |
| **Global Hotkeys** | ✅ F1-F5 anywhere | ❌ No |
| **Recording History** | ✅ Save unlimited | ⚠️ Basic |
| **Speed Control** | ✅ 0.1x - 5.0x | ⚠️ Limited |
| **Human-Like Mouse** | ✅ Smooth curves | ❌ Robotic |
| **Open Source** | ✅ GPL v3 | ❌ Closed |
| **File Size** | ✅ ~1 MB | ⚠️ 50-200 MB |
| **No Installation** | ✅ Portable .exe | ⚠️ Complex setup |

## Technical Details

### Built With:
- **Python 3.x** – Core engine
- **Tkinter** – Modern GUI
- **PyAutoGUI** – Mouse/keyboard automation
- **pynput** – Global hotkeys
- **NumPy** – Smooth Bézier curves

### Recording Format:
```json
{
  "events": [
    {
      "type": "click",
      "button": "left",
      "x": 500,
      "y": 300,
      "timestamp": 1234567890.123
    },
    {
      "type": "keypress",
      "key": "a",
      "timestamp": 1234567891.456
    },
    {
      "type": "drag",
      "from_x": 100,
      "from_y": 100,
      "to_x": 200,
      "to_y": 200,
      "duration": 1.5,
      "timestamp": 1234567893.000
    }
  ],
  "created": "20260105_143022",
  "duration": 15.5
}
```

### Platform Support:
- ✅ **Windows 10/11** – Full support
- ✅ **Linux** – Full support
- ⚠️ **macOS** – Limited (permission issues)

### System Requirements:
- **OS:** Windows 10+ or Linux
- **RAM:** 100 MB
- **Disk:** 1 MB (app) + recordings storage
- **Python:** Not required for .exe version

## Installation

### Option A: Windows Installer (Recommended)

```
1. Download: AutomationRecorder_Setup.exe
2. Install: Double-click (click "More info → Run anyway" if warning appears)
3. Launch: From Start Menu or Desktop
4. Press F1 and start automating!
```

**Note:** Windows SmartScreen may show a warning (normal for unsigned apps). Click "More info" → "Run anyway"

### Option B: Source Code (Most Secure)

```bash
# 1. Install Python 3.x (if not installed)
#    https://python.org — Check "Add to PATH"

# 2. Clone repository
git clone https://github.com/[your-repo]/AutomationRecorder.git
cd AutomationRecorder

# 3. Install dependencies
pip install -r requirements.txt

# 4. Run
python automation_recorder.py

# OR use convenience scripts:
install.bat  # Windows - install dependencies
run.bat      # Windows - launch app
```

### Option C: Portable .exe (No Installation)

```
1. Download: AutomationRecorder.exe (standalone)
2. Place anywhere on your computer
3. Double-click to run
4. No installation needed!
```

## Frequently Asked Questions

### ❓ Is this really 100% free?
**Yes!** Completely free, forever. No trials, no paid upgrades, no ads. Open-source GNU GPL v3.

### ❓ Why does Windows show a security warning?
The app isn't digitally signed (costs $100-500/year). Click "More info" → "Run anyway". The source code is open for inspection on GitHub.

### ❓ Can I edit my recordings?
Yes! Recordings are saved as JSON files in the `recordings/` folder. Edit with any text editor.

### ❓ Does this work in games?
Most games yes, but some anti-cheat systems may block it. Use at your own risk.

### ❓ How accurate is the replay?
Pixel-perfect! Mouse coordinates are recorded to the exact pixel, timings to the millisecond.

### ❓ Can I stop playback mid-recording?
Yes! Press **F2** anytime to stop.

### ❓ How many events can I record?
Unlimited! Only limited by your RAM and storage.

### ❓ Can I share my recordings?
Yes! Copy `.json` files from `recordings/` folder. Transfer to another user's `recordings/` folder.

### ❓ What's the file size?
- **App:** ~1 MB (standalone .exe with Python included)
- **Recordings:** 1-10 KB each (JSON format)

### ❓ Does it record passwords?
**Warning:** Yes! Keystrokes are recorded as plain text. **Never share recordings containing sensitive data.**

### ❓ Can I run multiple recordings in sequence?
Currently: Load → Play → Load next → Play. Future update may add playlist feature.

## Screenshots

### Main Interface
![Recording Tab](~/assets/images/automation-recorder-main.png)
*Clean, intuitive interface with real-time event display*

### History Manager
![History Tab](~/assets/images/automation-recorder-history.png)
*Browse, load, and manage all your saved recordings*

### Settings Panel
![Settings Tab](~/assets/images/automation-recorder-settings.png)
*Customize playback speed, mouse smoothness, and more*

## Security & Privacy

### ✅ Safe to Use
- Open-source code (inspect on GitHub)
- No internet connection required
- No data collection
- No telemetry
- All recordings stored locally

### ⚠️ Important Warnings
- **Keystrokes recorded as plain text** – Don't record passwords
- **Use responsibly** – Respect terms of service
- **Don't spam** – Avoid using for malicious automation
- **Test first** – Ensure automation is safe before looping

## Contribute

This is an open-source project! Contributions welcome:

- 🐛 **Report bugs** – [GitHub Issues](https://github.com/[repo]/issues)
- 💡 **Suggest features** – [Discussions](https://github.com/[repo]/discussions)
- 🔧 **Submit Pull Requests** – Improvements welcome
- ⭐ **Star on GitHub** – Support the project
- 📢 **Share with friends** – Spread the word

## Roadmap

### Coming Soon:
- 🌐 **Cloud sync** – Sync recordings across devices
- 📋 **Clipboard integration** – Auto-paste from clipboard
- 🎨 **Themes** – Dark mode & custom colors
- 📊 **Analytics** – Recording statistics
- 🔒 **Encryption** – Secure sensitive recordings
- 🎬 **Playlist mode** – Run multiple recordings in sequence
- 🖼️ **Image recognition** – Click based on screen content
- 🗣️ **Voice control** – Start/stop with voice commands

## License

```
GNU General Public License v3.0

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See <https://www.gnu.org/licenses/> for details.
```

## Credits

**Developer:** Harava

**Special Thanks:**
- Python community
- PyAutoGUI, pynput, NumPy contributors
- All testers and users

## Contact & Support

- **GitHub:** [github.com/[your-repo]/AutomationRecorder](https://github.com/[repo])
- **Issues:** [Report bugs](https://github.com/[repo]/issues)
- **Discussions:** [Community forum](https://github.com/[repo]/discussions)
- **Email:** [your-email@example.com]

## Quick Links

- 📥 **Download:** [Latest Release](https://github.com/[repo]/releases)
- 📖 **Documentation:** [Full Docs](BUILD_INSTRUCTIONS.md)
- 🐛 **Report Bug:** [Issues](https://github.com/[repo]/issues)
- 💬 **Community:** [Discussions](https://github.com/[repo]/discussions)

---

<div class="bg-gradient-to-r from-blue-500 to-indigo-600 rounded-2xl p-8 text-white text-center my-10">
  <h2 class="text-3xl font-bold mb-4">⚡ Fast. Free. Powerful. ⚡</h2>
  <p class="text-xl mb-6">Record once. Replay forever. Save hours daily.</p>
  <div class="flex gap-4 justify-center">
    <a href="https://github.com/[repo]/releases"
       class="py-4 px-8 rounded-xl bg-white text-blue-600 font-bold hover:bg-gray-100 transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-105">
      Download Now (Free)
    </a>
    <a href="https://github.com/[repo]"
       class="py-4 px-8 rounded-xl border-2 border-white text-white font-bold hover:bg-white hover:text-blue-600 transition-all duration-300">
      View on GitHub
    </a>
  </div>
</div>

---

<div align="center">

**Made with ❤️ using Python**

**GNU GPL v3 | 2024-2026**

⭐ **Star on GitHub if you love it!** ⭐

</div>
